/**
 * \file pappsomspp/core/processing/cbor/mzcbor/cvparammap.h
 * \date 02/02/2026
 * \author Olivier Langella
 * \brief cvParam map
 */

/*******************************************************************************
 * Copyright (c) 2026 Olivier Langella <Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of PAPPSOms-tools.
 *
 *     PAPPSOms-tools is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms-tools is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms-tools.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/


#pragma once
#include <QString>
#include <QXmlStreamWriter>
#include <QJsonArray>
#include <QCborStreamReader>
#include "cvparam.h"

namespace pappso
{
namespace cbor
{
namespace mzcbor
{
/**
 * @todo write docs
 */
struct CvParamMap : std::map<QString, pappso::cbor::mzcbor::CvParam>
{
  /** @brief fill the structure reading data from a CBOR stream
   * @param reader CBOR stream
   */
  void fromCbor(CborStreamReader &reader);

  /** @brief write the structure to a JSON array
   * @result QJsonObject
   */
  QJsonArray toJsonArray() const;
};
} // namespace mzcbor
} // namespace cbor
} // namespace pappso
