include "assert";
include "funcs";

(
  ([
    ".",
    ".a",
    ".a[0]",
    ".a[123].bb",
    ".[123].a",
    ".[123][123].a",
    ".\"b b\"",
    ".\"a \\\\ b\"",
    ".\"a \\\" b\""
  ][] | assert("\(.) | expr_to_path | path_to_expr"; .; expr_to_path | path_to_expr))
,
  ([
    [[], []],
    [[1], [[1]]],
    [[1,1], [[1,1]]],
    [[1,1,2], [[1,1],[2]]],
    [[1,1,2,2], [[1,1],[2,2]]],
    [[1,2,2,1], [[1],[2,2],[1]]]
  ][] | assert("\(.) | streaks"; .[1]; .[0] | streaks))
,
  ([
    [[{a:1},{a:1},{a:2}], [[{a:1},{a:1}],[{a:2}]]]
  ][] | assert("\(.) | streaks_by"; .[1]; .[0] | streaks_by(.a)))
,
  ([
    [[], 1, []],
    [[], 2, []],
    [[1], 1, [[1]]],
    [[1], 2, [[1]]],
    [[1,2], 1, [[1],[2]]],
    [[1,2], 2, [[1,2]]],
    [[1,2,3,4], 2, [[1,2],[3,4]]],
    [[1,2,3,4], 3, [[1,2,3],[4]]],
    ["", 1, []],
    ["", 2, []],
    ["1", 1, ["1"]],
    ["1", 2, ["1"]],
    ["12", 1, ["1","2"]],
    ["12", 2, ["12"]],
    ["1234", 2, ["12","34"]],
    ["1234", 3, ["123","4"]]
  ][] | . as $t | assert("\($t[0]) | chunk(\($t[1]))"; $t[2]; $t[0] | chunk($t[1])))
)
