import { IVec2 } from "../point/interface";
export interface Box {
    xMin: number;
    xMax: number;
    yMin: number;
    yMax: number;
}
export declare function empty(): {
    xMin: number;
    xMax: number;
    yMin: number;
    yMax: number;
};
export declare function isValid(b: Box): boolean;
export declare function coverPoint(b: Box, z: IVec2): void;
export declare function coverX(b: Box, x: number): void;
export declare function coverY(b: Box, y: number): void;
export declare function coverBox(b: Box, t: Box): void;
export declare function intersects(a: Box, b: Box): boolean;
