/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.CoordinateSystem;
import visad.DataDisplayLink;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.DisplayRenderer;
import visad.DisplayTupleType;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Gridded2DSet;
import visad.Integer2DSet;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.ScalarMap;
import visad.SetType;
import visad.ShadowRealTupleType;
import visad.ShadowRealType;
import visad.ShadowSetType;
import visad.ShadowType;
import visad.UnionSet;
import visad.Unit;
import visad.VisADException;
import visad.VisADRay;
import visad.bom.CurveDelete;
import visad.bom.ShadowCurveSetTypeJ2D;
import visad.collab.CollabUtil;
import visad.java2d.DefaultRendererJ2D;
import visad.java2d.DirectManipulationRendererJ2D;
import visad.java2d.DisplayImplJ2D;

public class CurveManipulationRendererJ2D
extends DirectManipulationRendererJ2D {
    private int mouseModifiersMask = 0;
    private int mouseModifiersValue = 0;
    private boolean only_one = false;
    private float[][] spatialValues = null;
    private int closeIndex = -1;
    private transient DataDisplayLink link = null;
    private transient DataReference ref = null;
    private transient MathType type = null;
    private transient ShadowSetType shadow = null;
    private transient RealType[] domain_reals;
    float[] default_values;
    private float point_x;
    private float point_y;
    private float point_z;
    private float line_x;
    private float line_y;
    private float line_z;
    private float[] f = new float[1];
    private float[] d = new float[1];
    private float[] value = new float[2];
    private String whyNotDirect = null;
    private int[] axisToComponent = new int[]{-1, -1, -1};
    private ScalarMap[] directMap = new ScalarMap[]{null, null, null};
    private int directManifoldDimension = 2;
    DisplayTupleType tuple;
    private CoordinateSystem tuplecs;
    private int otherindex = -1;
    private float othervalue;
    private static final String notSetType = "not Set";
    private static final String notTwoD = "Set must have domain dimension = 2";
    private static final String domainNotSpatial = "domain must be mapped to spatial";
    private static final String badCoordSysManifoldDim = "directManifoldDimension must be 2 with spatial CoordinateSystem";
    private boolean stop = false;
    private float offsetx = 0.0f;
    private float offsety = 0.0f;
    private float offsetz = 0.0f;
    private int offset_count = 0;
    private static final int OFFSET_COUNT_INIT = 30;
    int which_set = -1;
    int which_point = -1;
    private static final int N = 64;

    public CurveManipulationRendererJ2D() {
        this(0, 0);
    }

    public CurveManipulationRendererJ2D(int mmm, int mmv) {
        this(mmm, mmv, false);
    }

    public CurveManipulationRendererJ2D(int mmm, int mmv, boolean oo) {
        this.mouseModifiersMask = mmm;
        this.mouseModifiersValue = mmv;
        this.only_one = oo;
    }

    public ShadowType makeShadowSetType(SetType type, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        return new ShadowCurveSetTypeJ2D(type, link, parent);
    }

    public void checkDirect() throws VisADException, RemoteException {
        this.setIsDirectManipulation(false);
        DisplayImpl display = this.getDisplay();
        DataDisplayLink[] Links = this.getLinks();
        if (Links == null || Links.length == 0) {
            this.link = null;
            return;
        }
        this.link = Links[0];
        this.ref = this.link.getDataReference();
        this.default_values = this.link.getDefaultValues();
        this.type = this.link.getType();
        if (!(this.type instanceof SetType)) {
            this.whyNotDirect = notSetType;
            return;
        }
        RealTupleType real_tuple = ((SetType)this.type).getDomain();
        this.domain_reals = real_tuple.getRealComponents();
        this.shadow = (ShadowSetType)this.link.getShadow().getAdaptedShadowType();
        ShadowRealTupleType domain = this.shadow.getDomain();
        this.directMap = new ScalarMap[]{null, null, null};
        ShadowRealType[] components = this.shadow.getDomain().getRealComponents();
        if (components.length != 2) {
            this.whyNotDirect = notTwoD;
            return;
        }
        this.tuple = domain.getDisplaySpatialTuple();
        if (!(Display.DisplaySpatialCartesianTuple.equals(this.tuple) || this.tuple != null && this.tuple.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple))) {
            this.whyNotDirect = domainNotSpatial;
            return;
        }
        int[] indices = new int[]{-1, -1};
        for (int i = 0; i < components.length; ++i) {
            Enumeration maps = components[i].getSelectedMapVector().elements();
            while (maps.hasMoreElements()) {
                ScalarMap map = (ScalarMap)maps.nextElement();
                DisplayRealType dreal = map.getDisplayScalar();
                DisplayTupleType tuple = dreal.getTuple();
                if (tuple == null || !tuple.equals(Display.DisplaySpatialCartesianTuple) && (tuple.getCoordinateSystem() == null || !tuple.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple))) continue;
                int index = dreal.getTupleIndex();
                this.axisToComponent[index] = i;
                this.directMap[index] = map;
                indices[i] = index;
            }
        }
        if (indices[0] < 0 || indices[1] < 0) {
            this.whyNotDirect = domainNotSpatial;
            return;
        }
        this.otherindex = 3 - (indices[0] + indices[1]);
        DisplayRealType dreal = (DisplayRealType)this.tuple.getComponent(this.otherindex);
        int index = this.getDisplay().getDisplayScalarIndex(dreal);
        float f = this.othervalue = index > 0 ? this.default_values[index] : (float)dreal.getDefaultValue();
        if (Display.DisplaySpatialCartesianTuple.equals(this.tuple)) {
            this.tuple = null;
            this.tuplecs = null;
        } else {
            this.tuplecs = this.tuple.getCoordinateSystem();
        }
        this.directManifoldDimension = 2;
        this.setIsDirectManipulation(true);
    }

    private int getDirectManifoldDimension() {
        return this.directManifoldDimension;
    }

    public String getWhyNotDirect() {
        return this.whyNotDirect;
    }

    private int getAxisToComponent(int i) {
        return this.axisToComponent[i];
    }

    private ScalarMap getDirectMap(int i) {
        return this.directMap[i];
    }

    public void addPoint(float[] x) throws VisADException {
    }

    public synchronized void setSpatialValues(float[][] spatial_values) {
        this.spatialValues = spatial_values;
    }

    public synchronized float checkClose(double[] origin, double[] direction) {
        int mouseModifiers = this.getLastMouseModifiers();
        if ((mouseModifiers & this.mouseModifiersMask) != this.mouseModifiersValue) {
            return Float.MAX_VALUE;
        }
        float distance = Float.MAX_VALUE;
        this.closeIndex = -1;
        if (this.spatialValues != null) {
            float o_x = (float)origin[0];
            float o_y = (float)origin[1];
            float o_z = (float)origin[2];
            float d_x = (float)direction[0];
            float d_y = (float)direction[1];
            float d_z = (float)direction[2];
            for (int i = 0; i < this.spatialValues[0].length; ++i) {
                float dot;
                float d;
                float x = this.spatialValues[0][i] - o_x;
                float y = this.spatialValues[1][i] - o_y;
                float z = this.spatialValues[2][i] - o_z;
                if (!((d = (float)Math.sqrt((x -= (dot = x * d_x + y * d_y + z * d_z) * d_x) * x + (y -= dot * d_y) * y + (z -= dot * d_z) * z)) < distance)) continue;
                distance = d;
                this.closeIndex = i;
                this.offsetx = x;
                this.offsety = y;
                this.offsetz = z;
            }
            if (distance <= this.getDisplayRenderer().getPickThreshhold()) {
                return distance;
            }
        }
        this.offsetx = 0.0f;
        this.offsety = 0.0f;
        this.offsetz = 0.0f;
        this.closeIndex = -1;
        try {
            float r = this.findRayManifoldIntersection(true, origin, direction, this.tuple, this.otherindex, this.othervalue);
            if (r == r) {
                return 0.0f;
            }
            return Float.MAX_VALUE;
        }
        catch (VisADException ex) {
            return Float.MAX_VALUE;
        }
    }

    public synchronized void release_direct() {
    }

    public void stop_direct() {
        this.stop = true;
    }

    public synchronized void drag_direct(VisADRay ray, boolean first, int mouseModifiers) {
        if (this.ref == null || this.shadow == null) {
            return;
        }
        if (first) {
            this.stop = false;
        } else if (this.stop) {
            return;
        }
        double[] origin = new double[]{ray.position[0], ray.position[1], ray.position[2]};
        double[] direction = ray.vector;
        if (this.pickCrawlToCursor) {
            if (first) {
                this.offset_count = 30;
            } else if (this.offset_count > 0) {
                --this.offset_count;
            }
            if (this.offset_count > 0) {
                float mult = (float)this.offset_count / 30.0f;
                origin[0] = origin[0] + (double)(mult * this.offsetx);
                origin[1] = origin[1] + (double)(mult * this.offsety);
                origin[2] = origin[2] + (double)(mult * this.offsetz);
            }
        }
        try {
            int len;
            UnionSet data;
            float r = this.findRayManifoldIntersection(true, origin, direction, this.tuple, this.otherindex, this.othervalue);
            if (r != r) {
                return;
            }
            Object xcs = new float[][]{{(float)(origin[0] + (double)r * direction[0])}, {(float)(origin[1] + (double)r * direction[1])}, {(float)(origin[2] + (double)r * direction[2])}};
            float[] xx = new float[]{xcs[0][0], xcs[1][0], xcs[2][0]};
            if (this.tuple != null) {
                if (this.tuplecs == null) {
                    return;
                }
                xcs = this.tuplecs.fromReference((float[][])xcs);
            }
            float[] x = new float[]{xcs[0][0], xcs[1][0], xcs[2][0]};
            this.addPoint(xx);
            try {
                data = (UnionSet)this.link.getData();
            }
            catch (RemoteException re) {
                if (CollabUtil.isDisconnectException(re)) {
                    this.getDisplay().connectionFailed(this, this.link);
                    this.removeLink(this.link);
                    return;
                }
                throw re;
            }
            if (data == null) {
                return;
            }
            SampledSet[] sets = data.getSets();
            int n = sets.length;
            UnionSet newData = null;
            Vector<String> vect = new Vector<String>();
            for (int i = 0; i < 3; ++i) {
                int j = this.getAxisToComponent(i);
                if (j < 0) continue;
                this.f[0] = x[i];
                ScalarMap dm = this.getDirectMap(i);
                if (dm == null) {
                    return;
                }
                this.d = dm.inverseScaleValues(this.f);
                this.value[j] = this.d[0];
                RealType rtype = this.domain_reals[j];
                Real rr = new Real(rtype, (double)this.d[0]);
                Unit overrideUnit = dm.getOverrideUnit();
                Unit rtunit = rtype.getDefaultUnit();
                if (overrideUnit != null && !overrideUnit.equals(rtunit) && !RealType.Time.equals(rtype)) {
                    double dval = overrideUnit.toThis(this.d[0], rtunit);
                    rr = new Real(rtype, dval, overrideUnit);
                }
                String valueString = rr.toValueString();
                vect.addElement(rtype.getName() + " = " + valueString);
            }
            this.getDisplayRenderer().setCursorStringVector(vect);
            if (this.closeIndex < 0) {
                if (first) {
                    if (this.only_one) {
                        SampledSet[] new_sets = new SampledSet[1];
                        float[][] new_samples = new float[][]{{this.value[0]}, {this.value[1]}};
                        new_sets[0] = new Gridded2DSet(this.type, (float[][])new_samples, 1, data.getCoordinateSystem(), data.getSetUnits(), null);
                        newData = new UnionSet(this.type, new_sets);
                    } else {
                        SampledSet[] new_sets = new SampledSet[n + 1];
                        System.arraycopy(sets, 0, new_sets, 0, n);
                        float[][] new_samples = new float[][]{{this.value[0]}, {this.value[1]}};
                        new_sets[n] = new Gridded2DSet(this.type, (float[][])new_samples, 1, data.getCoordinateSystem(), data.getSetUnits(), null);
                        newData = new UnionSet(this.type, new_sets);
                    }
                } else {
                    float[][] samples = sets[n - 1].getSamples(false);
                    int m = samples[0].length;
                    float[][] new_samples = new float[2][m + 1];
                    System.arraycopy(samples[0], 0, new_samples[0], 0, m);
                    System.arraycopy(samples[1], 0, new_samples[1], 0, m);
                    new_samples[0][m] = this.value[0];
                    new_samples[1][m] = this.value[1];
                    sets[n - 1] = new Gridded2DSet(this.type, new_samples, m + 1, data.getCoordinateSystem(), data.getSetUnits(), null);
                    newData = new UnionSet(this.type, sets);
                }
            } else if (first) {
                this.which_set = -1;
                this.which_point = -1;
                int w = this.closeIndex;
                len = 0;
                for (int i = 0; i < n; ++i) {
                    len = sets[i].getLength();
                    if (w < len) {
                        this.which_set = i;
                        this.which_point = w;
                        break;
                    }
                    w -= len;
                }
                if (this.which_set < 0) {
                    return;
                }
                float[][] samples = sets[this.which_set].getSamples(false);
                if (this.which_point == 0) {
                    samples = this.invert(samples);
                    this.which_point = len - 1;
                }
                samples[0][this.which_point] = this.value[0];
                samples[1][this.which_point] = this.value[1];
                if (this.which_point == len - 1) {
                    sets = this.rotate(sets, this.which_set);
                    this.which_set = n - 1;
                    this.closeIndex = -1;
                }
                sets[this.which_set] = new Gridded2DSet(this.type, samples, len, data.getCoordinateSystem(), data.getSetUnits(), null);
                newData = new UnionSet(this.type, sets);
            } else {
                if (this.which_set < 0) {
                    return;
                }
                float[][] samples = sets[this.which_set].getSamples(false);
                len = samples[0].length;
                int dir = 0;
                if (this.which_point == 0) {
                    dir = 1;
                } else if (this.which_point == len - 1) {
                    dir = -1;
                } else {
                    float v0 = this.value[0] - samples[0][this.which_point];
                    float v1 = this.value[1] - samples[1][this.which_point];
                    float v = (float)Math.sqrt(v0 * v0 + v1 * v1);
                    int NPTS = 5;
                    int wp = this.which_point + NPTS;
                    if (wp > len - 2) {
                        wp = len - 2;
                    }
                    float pplus = 0.0f;
                    float psum = 0.0f;
                    for (int i = this.which_point; i < wp; ++i) {
                        float vp0 = samples[0][i + 1] - samples[0][i];
                        float vp1 = samples[1][i + 1] - samples[1][i];
                        float vp = (float)Math.sqrt(vp0 * vp0 + vp1 * vp1);
                        float pp = (v0 * vp0 + v1 * vp1) / v * vp;
                        if ((double)pp > 0.0) {
                            pplus += 1.0f;
                        }
                        psum += pp;
                    }
                    float pdiv = wp - this.which_point > 0 ? (float)(wp - this.which_point) : 1.0f;
                    pplus /= pdiv;
                    psum /= pdiv;
                    int wm = this.which_point - NPTS;
                    if (wm < 1) {
                        wm = 1;
                    }
                    float mplus = 0.0f;
                    float msum = 0.0f;
                    for (int i = this.which_point; i > wm; --i) {
                        float vm0 = samples[0][i - 1] - samples[0][i];
                        float vm1 = samples[1][i - 1] - samples[1][i];
                        float vm = (float)Math.sqrt(vm0 * vm0 + vm1 * vm1);
                        float mm = (v0 * vm0 + v1 * vm1) / v * vm;
                        if ((double)mm > 0.0) {
                            mplus += 1.0f;
                        }
                        msum += mm;
                    }
                    float mdiv = this.which_point - wm > 0 ? (float)(this.which_point - wm) : 1.0f;
                    msum /= mdiv;
                    int n2 = dir = pplus > (mplus /= mdiv) ? 1 : -1;
                    if (pplus == mplus) {
                        dir = psum > msum ? 1 : -1;
                    }
                }
                float distance = Float.MAX_VALUE;
                int new_point = -1;
                if (dir > 0) {
                    for (int i = this.which_point + 1; i < len; ++i) {
                        float d = (samples[0][i] - this.value[0]) * (samples[0][i] - this.value[0]) + (samples[1][i] - this.value[1]) * (samples[1][i] - this.value[1]);
                        if (!(d < distance)) continue;
                        distance = d;
                        new_point = i;
                    }
                    if (new_point < 0) {
                        return;
                    }
                    if (this.which_point + 1 == new_point) {
                        if (this.which_point + 2 == len) {
                            samples[0][this.which_point + 1] = this.value[0];
                            samples[1][this.which_point + 1] = this.value[1];
                            ++this.which_point;
                        } else {
                            float[][] new_samples = new float[2][len + 1];
                            System.arraycopy(samples[0], 0, new_samples[0], 0, this.which_point + 1);
                            System.arraycopy(samples[1], 0, new_samples[1], 0, this.which_point + 1);
                            new_samples[0][this.which_point + 1] = this.value[0];
                            new_samples[1][this.which_point + 1] = this.value[1];
                            System.arraycopy(samples[0], this.which_point + 1, new_samples[0], this.which_point + 2, len - (this.which_point + 1));
                            System.arraycopy(samples[1], this.which_point + 1, new_samples[1], this.which_point + 2, len - (this.which_point + 1));
                            samples = new_samples;
                            ++this.which_point;
                            ++len;
                        }
                    } else if (this.which_point + 2 == new_point) {
                        samples[0][this.which_point + 1] = this.value[0];
                        samples[1][this.which_point + 1] = this.value[1];
                        ++this.which_point;
                    } else {
                        int new_len = len - (new_point - (this.which_point + 2));
                        float[][] new_samples = new float[2][new_len];
                        System.arraycopy(samples[0], 0, new_samples[0], 0, this.which_point + 1);
                        System.arraycopy(samples[1], 0, new_samples[1], 0, this.which_point + 1);
                        new_samples[0][this.which_point + 1] = this.value[0];
                        new_samples[1][this.which_point + 1] = this.value[1];
                        System.arraycopy(samples[0], new_point, new_samples[0], this.which_point + 2, len - new_point);
                        System.arraycopy(samples[1], new_point, new_samples[1], this.which_point + 2, len - new_point);
                        samples = new_samples;
                        ++this.which_point;
                        len = new_len;
                    }
                } else {
                    for (int i = 0; i < this.which_point; ++i) {
                        float d = (samples[0][i] - this.value[0]) * (samples[0][i] - this.value[0]) + (samples[1][i] - this.value[1]) * (samples[1][i] - this.value[1]);
                        if (!(d < distance)) continue;
                        distance = d;
                        new_point = i;
                    }
                    if (new_point < 0) {
                        return;
                    }
                    if (new_point == this.which_point - 1) {
                        if (this.which_point - 1 == 0) {
                            samples[0][this.which_point - 1] = this.value[0];
                            samples[1][this.which_point - 1] = this.value[1];
                            --this.which_point;
                        } else {
                            float[][] new_samples = new float[2][len + 1];
                            System.arraycopy(samples[0], 0, new_samples[0], 0, this.which_point);
                            System.arraycopy(samples[1], 0, new_samples[1], 0, this.which_point);
                            new_samples[0][this.which_point] = this.value[0];
                            new_samples[1][this.which_point] = this.value[1];
                            System.arraycopy(samples[0], this.which_point, new_samples[0], this.which_point + 1, len - this.which_point);
                            System.arraycopy(samples[1], this.which_point, new_samples[1], this.which_point + 1, len - this.which_point);
                            samples = new_samples;
                            ++len;
                        }
                    } else if (new_point == this.which_point - 2) {
                        samples[0][this.which_point - 1] = this.value[0];
                        samples[1][this.which_point - 1] = this.value[1];
                        --this.which_point;
                    } else {
                        int new_len = len - (this.which_point - 2 - new_point);
                        float[][] new_samples = new float[2][new_len];
                        System.arraycopy(samples[0], 0, new_samples[0], 0, new_point + 1);
                        System.arraycopy(samples[1], 0, new_samples[1], 0, new_point + 1);
                        new_samples[0][new_point + 1] = this.value[0];
                        new_samples[1][new_point + 1] = this.value[1];
                        System.arraycopy(samples[0], this.which_point, new_samples[0], new_point + 2, len - this.which_point);
                        System.arraycopy(samples[1], this.which_point, new_samples[1], new_point + 2, len - this.which_point);
                        samples = new_samples;
                        this.which_point = new_point + 1;
                        len = new_len;
                    }
                }
                if (this.which_point == 0) {
                    samples = this.invert(samples);
                    this.which_point = len - 1;
                }
                if (this.which_point == len - 1) {
                    sets = this.rotate(sets, this.which_set);
                    this.which_set = n - 1;
                    this.closeIndex = -1;
                }
                sets[this.which_set] = new Gridded2DSet(this.type, samples, len, data.getCoordinateSystem(), data.getSetUnits(), null);
                newData = new UnionSet(this.type, sets);
            }
            this.ref.setData(newData);
            this.link.clearData();
        }
        catch (VisADException e) {
            System.out.println("drag_direct " + e);
            e.printStackTrace();
        }
        catch (RemoteException e) {
            System.out.println("drag_direct " + e);
            e.printStackTrace();
        }
    }

    private float[][] invert(float[][] samples) {
        int m = samples[0].length;
        float[][] new_samples = new float[2][m];
        int m1 = m - 1;
        for (int i = 0; i < m; ++i) {
            new_samples[0][i] = samples[0][m1 - i];
            new_samples[1][i] = samples[1][m1 - i];
        }
        return new_samples;
    }

    private SampledSet[] rotate(SampledSet[] sets, int which_set) {
        int n = sets.length;
        int k = n - 1 - which_set;
        if (k == 0) {
            return sets;
        }
        SampledSet[] new_sets = new SampledSet[n];
        if (which_set > 0) {
            System.arraycopy(sets, 0, new_sets, 0, which_set);
        }
        if (k > 0) {
            System.arraycopy(sets, which_set + 1, new_sets, which_set, k);
        }
        new_sets[n - 1] = sets[which_set];
        return new_sets;
    }

    public Object clone() {
        return new CurveManipulationRendererJ2D(this.mouseModifiersMask, this.mouseModifiersValue, this.only_one);
    }

    public static void main(String[] args) throws VisADException, RemoteException {
        RealType x = RealType.getRealType("x");
        RealType y = RealType.getRealType("y");
        RealTupleType xy = new RealTupleType(x, y);
        RealType c = RealType.getRealType("c");
        FunctionType ft = new FunctionType(xy, c);
        DisplayImplJ2D display = new DisplayImplJ2D("display1");
        display.addMap(new ScalarMap(x, Display.XAxis));
        display.addMap(new ScalarMap(y, Display.YAxis));
        display.addMap(new ScalarMap(c, Display.RGB));
        DisplayRenderer displayRenderer = display.getDisplayRenderer();
        displayRenderer.setBoxOn(false);
        GraphicsModeControl mode = ((DisplayImpl)display).getGraphicsModeControl();
        mode.setLineWidth(2.0f);
        Integer2DSet fset = new Integer2DSet((MathType)xy, 64, 64);
        FlatField field = new FlatField(ft, fset);
        float[][] values = new float[1][4096];
        int k = 0;
        for (int i = 0; i < 64; ++i) {
            for (int j = 0; j < 64; ++j) {
                values[0][k++] = (i - 32) * (j - 32);
            }
        }
        field.setSamples(values);
        DataReferenceImpl field_ref = new DataReferenceImpl("field");
        field_ref.setData(field);
        DefaultRendererJ2D renderer = new DefaultRendererJ2D();
        display.addReferences((DataRenderer)renderer, field_ref);
        renderer.toggle(false);
        Gridded2DSet set1 = new Gridded2DSet((MathType)xy, (float[][])new float[][]{{0.0f}, {0.0f}}, 1);
        SampledSet[] sets = new Gridded2DSet[]{set1};
        UnionSet set = new UnionSet((MathType)xy, sets);
        DataReferenceImpl ref = new DataReferenceImpl("set");
        ref.setData(set);
        boolean only_one = args.length > 1;
        CurveManipulationRendererJ2D cmr = new CurveManipulationRendererJ2D(0, 0, only_one);
        display.addReferences((DataRenderer)cmr, ref);
        JFrame frame = new JFrame("test CurveManipulationRendererJ2D");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setAlignmentY(0.0f);
        panel.setAlignmentX(0.0f);
        frame.getContentPane().add(panel);
        panel.add(display.getComponent());
        JPanel button_panel = new JPanel();
        button_panel.setLayout(new BoxLayout(button_panel, 0));
        button_panel.setAlignmentY(0.0f);
        button_panel.setAlignmentX(0.0f);
        CurveDelete cd = new CurveDelete(ref, display);
        if (!only_one) {
            JButton del = new JButton("delete last");
            del.addActionListener(cd);
            del.setActionCommand("del");
            button_panel.add(del);
        }
        JButton fill = new JButton("fill");
        fill.addActionListener(cd);
        fill.setActionCommand("fill");
        button_panel.add(fill);
        panel.add(button_panel);
        panel.add(button_panel);
        frame.setSize(500, 500);
        frame.setVisible(true);
    }
}

