#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Stacking
# send your bug reports to bugs@dotslashplay.it
###

script_version=20251015.2

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='stacking'
GAME_NAME='Stacking'

ARCHIVE_BASE_HUMBLE_0_NAME='Stacking-Linux-2013-06-04-setup.bin'
ARCHIVE_BASE_HUMBLE_0_MD5='4194bb869d537d40da7ad7f65b1102ed'
## This is a MojoSetup installer not relying on a Makeself wrapper.
ARCHIVE_BASE_HUMBLE_0_EXTRACTOR='bsdtar'
ARCHIVE_BASE_HUMBLE_0_SIZE='1505540'
ARCHIVE_BASE_HUMBLE_0_VERSION='2013.06.04-humble160616'
ARCHIVE_BASE_HUMBLE_0_URL='https://www.humblebundle.com/store/stacking'

ARCHIVE_BASE_GOG_0_NAME='gog_stacking_2.0.0.4.sh'
ARCHIVE_BASE_GOG_0_MD5='c32245091358bd97ac3e73c7f8bb937b'
## TODO: This size is copied (and rounded up) from the Humble Bundle archive.
##       It should be replaced by the actual value measured from the real GOG installer.
ARCHIVE_BASE_GOG_0_SIZE='1600000'
ARCHIVE_BASE_GOG_0_VERSION='1.0-gog2.0.0.4'
ARCHIVE_BASE_GOG_0_URL='https://www.gog.com/game/stacking'

CONTENT_PATH_DEFAULT_HUMBLE='data'
CONTENT_PATH_DEFAULT_GOG='data/noarch/game'
CONTENT_LIBS_BIN_RELATIVE_PATH='lib'
CONTENT_LIBS_BIN_FILES='
libfmodevent-4.42.16.so
libfmodeventnet-4.42.16.so
libfmodex-4.42.16.so'
CONTENT_GAME_BIN_FILES='
Stack.bin.x86'
CONTENT_GAME_L10N_FR_FILES='
Linux/Packs/Loc_frFR.~?'
CONTENT_GAME_L10N_EN_FILES='
Linux/Packs/Loc_enUS.~?'
CONTENT_GAME_DATA_FILES='
Data
OGL
Win
Linux/Packs/00Startup.~?
Linux/Packs/DLC1_Stuff.~?
Linux/Packs/RgB_Stuff.~?
Linux/Packs/Rg_Chars.~?
Linux/Packs/RgS_Stuff.~?
Linux/Packs/_Unused.~?
Linux/Packs/Man_*.~?
Stack.png
DFCONFIG'

APP_MAIN_EXE='Stack.bin.x86'
APP_MAIN_ICON='Stack.png'

PACKAGES_LIST='
PKG_BIN
PKG_L10N_FR
PKG_L10N_EN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_L10N
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libGL.so.1
libGLU.so.1
libm.so.6
libpthread.so.0
libSDL2-2.0.so.0
libstdc++.so.6
libz.so.1'

PKG_L10N_ID="${GAME_ID}-l10n"
PKG_L10N_FR_ID="${PKG_L10N_ID}-fr"
PKG_L10N_EN_ID="${PKG_L10N_ID}-en"
PKG_L10N_PROVIDES="
$PKG_L10N_ID"
PKG_L10N_FR_DESCRIPTION='French localisation'
PKG_L10N_EN_DESCRIPTION='English localisation'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Create localisation setting file.

mkdir --parents \
	"$(package_path 'PKG_L10N_FR')$(path_game_data)/Data/Config" \
	"$(package_path 'PKG_L10N_EN')$(path_game_data)/Data/Config"
cat > "$(package_path 'PKG_L10N_FR')$(path_game_data)/Data/Config/Language.cfg" << EOF
language='frFR'
EOF
cat > "$(package_path 'PKG_L10N_EN')$(path_game_data)/Data/Config/Language.cfg" << EOF
language='enUS'
EOF

# Write launchers.

launchers_generation

# Build package.

packages_generation
case "$(messages_language)" in
	('fr')
		lang_string='version %s :'
		lang_fr='française'
		lang_en='anglaise'
	;;
	('en'|*)
		lang_string='%s version:'
		lang_fr='French'
		lang_en='English'
	;;
esac
printf '\n'
printf "$lang_string" "$lang_fr"
print_instructions 'PKG_BIN' 'PKG_DATA' 'PKG_L10N_FR'
printf "$lang_string" "$lang_en"
print_instructions 'PKG_BIN' 'PKG_DATA' 'PKG_L10N_EN'

# Clean up.

working_directory_cleanup

exit 0
