
// LLDB C++ API Test: verify the event description as obtained by calling
// SBEvent::GetCStringFromEvent that is received by an
// SBListener object registered with a process with a breakpoint.

#include <atomic>
#include <iostream>
#include <string>
#include <thread>

#include "lldb-headers.h"

#include "common.h"

using namespace lldb;
using namespace std;

// listener thread control
extern atomic<bool> g_done;

// used by listener thread to communicate a successful process continue command
// back to the checking thread.

multithreaded_queue<bool> g_process_started;

extern SBListener g_listener;

void listener_func() {
  while (!g_done) {
    SBEvent event;
    bool got_event = g_listener.WaitForEvent(1, event);
    if (got_event) {
      if (!event.IsValid())
        throw Exception("event is not valid in listener thread");

      SBProcess process = SBProcess::GetProcessFromEvent(event);
      if (process.GetState() == eStateStopped) {
        SBError error = process.Continue();
        if (!error.Success())
          throw Exception(string("Cannot continue process from listener thread: ")
                          + error.GetCString());
        g_process_started.push(true);
      }
    }
  }
}

void check_listener(SBDebugger &dbg) {
  bool got_message = false;
  while (!got_message)
    g_process_started.pop(5, got_message);
  g_done = true;
}
