; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+sse2 | FileCheck %s --check-prefix=SSE
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+avx2 | FileCheck %s --check-prefix=AVX

;
; Float Comparisons
; Only equal/not-equal/ordered/unordered can be safely commuted
;

define <4 x i32> @commute_cmpps_eq(<4 x float>* %a0, <4 x float> %a1) {
; SSE-LABEL: commute_cmpps_eq:
; SSE:       # BB#0:
; SSE-NEXT:    cmpeqps (%rdi), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: commute_cmpps_eq:
; AVX:       # BB#0:
; AVX-NEXT:    vcmpeqps (%rdi), %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = load <4 x float>, <4 x float>* %a0
  %2 = fcmp oeq <4 x float> %1, %a1
  %3 = sext <4 x i1> %2 to <4 x i32>
  ret <4 x i32> %3
}

define <4 x i32> @commute_cmpps_ne(<4 x float>* %a0, <4 x float> %a1) {
; SSE-LABEL: commute_cmpps_ne:
; SSE:       # BB#0:
; SSE-NEXT:    cmpneqps (%rdi), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: commute_cmpps_ne:
; AVX:       # BB#0:
; AVX-NEXT:    vcmpneqps (%rdi), %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = load <4 x float>, <4 x float>* %a0
  %2 = fcmp une <4 x float> %1, %a1
  %3 = sext <4 x i1> %2 to <4 x i32>
  ret <4 x i32> %3
}

define <4 x i32> @commute_cmpps_ord(<4 x float>* %a0, <4 x float> %a1) {
; SSE-LABEL: commute_cmpps_ord:
; SSE:       # BB#0:
; SSE-NEXT:    cmpordps (%rdi), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: commute_cmpps_ord:
; AVX:       # BB#0:
; AVX-NEXT:    vcmpordps (%rdi), %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = load <4 x float>, <4 x float>* %a0
  %2 = fcmp ord <4 x float> %1, %a1
  %3 = sext <4 x i1> %2 to <4 x i32>
  ret <4 x i32> %3
}

define <4 x i32> @commute_cmpps_uno(<4 x float>* %a0, <4 x float> %a1) {
; SSE-LABEL: commute_cmpps_uno:
; SSE:       # BB#0:
; SSE-NEXT:    cmpunordps (%rdi), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: commute_cmpps_uno:
; AVX:       # BB#0:
; AVX-NEXT:    vcmpunordps (%rdi), %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = load <4 x float>, <4 x float>* %a0
  %2 = fcmp uno <4 x float> %1, %a1
  %3 = sext <4 x i1> %2 to <4 x i32>
  ret <4 x i32> %3
}

define <4 x i32> @commute_cmpps_ueq(<4 x float>* %a0, <4 x float> %a1) {
; SSE-LABEL: commute_cmpps_ueq:
; SSE:       # BB#0:
; SSE-NEXT:    movaps (%rdi), %xmm1
; SSE-NEXT:    movaps %xmm1, %xmm2
; SSE-NEXT:    cmpeqps %xmm0, %xmm2
; SSE-NEXT:    cmpunordps %xmm1, %xmm0
; SSE-NEXT:    orps %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: commute_cmpps_ueq:
; AVX:       # BB#0:
; AVX-NEXT:    vmovaps (%rdi), %xmm1
; AVX-NEXT:    vcmpeqps %xmm0, %xmm1, %xmm2
; AVX-NEXT:    vcmpunordps %xmm0, %xmm1, %xmm0
; AVX-NEXT:    vorps %xmm2, %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = load <4 x float>, <4 x float>* %a0
  %2 = fcmp ueq <4 x float> %1, %a1
  %3 = sext <4 x i1> %2 to <4 x i32>
  ret <4 x i32> %3
}

define <4 x i32> @commute_cmpps_one(<4 x float>* %a0, <4 x float> %a1) {
; SSE-LABEL: commute_cmpps_one:
; SSE:       # BB#0:
; SSE-NEXT:    movaps (%rdi), %xmm1
; SSE-NEXT:    movaps %xmm1, %xmm2
; SSE-NEXT:    cmpneqps %xmm0, %xmm2
; SSE-NEXT:    cmpordps %xmm1, %xmm0
; SSE-NEXT:    andps %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: commute_cmpps_one:
; AVX:       # BB#0:
; AVX-NEXT:    vmovaps (%rdi), %xmm1
; AVX-NEXT:    vcmpneqps %xmm0, %xmm1, %xmm2
; AVX-NEXT:    vcmpordps %xmm0, %xmm1, %xmm0
; AVX-NEXT:    vandps %xmm2, %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = load <4 x float>, <4 x float>* %a0
  %2 = fcmp one <4 x float> %1, %a1
  %3 = sext <4 x i1> %2 to <4 x i32>
  ret <4 x i32> %3
}

define <4 x i32> @commute_cmpps_lt(<4 x float>* %a0, <4 x float> %a1) {
; SSE-LABEL: commute_cmpps_lt:
; SSE:       # BB#0:
; SSE-NEXT:    movaps (%rdi), %xmm1
; SSE-NEXT:    cmpltps %xmm0, %xmm1
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: commute_cmpps_lt:
; AVX:       # BB#0:
; AVX-NEXT:    vmovaps (%rdi), %xmm1
; AVX-NEXT:    vcmpltps %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
  %1 = load <4 x float>, <4 x float>* %a0
  %2 = fcmp olt <4 x float> %1, %a1
  %3 = sext <4 x i1> %2 to <4 x i32>
  ret <4 x i32> %3
}

define <4 x i32> @commute_cmpps_le(<4 x float>* %a0, <4 x float> %a1) {
; SSE-LABEL: commute_cmpps_le:
; SSE:       # BB#0:
; SSE-NEXT:    movaps (%rdi), %xmm1
; SSE-NEXT:    cmpleps %xmm0, %xmm1
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: commute_cmpps_le:
; AVX:       # BB#0:
; AVX-NEXT:    vmovaps (%rdi), %xmm1
; AVX-NEXT:    vcmpleps %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
  %1 = load <4 x float>, <4 x float>* %a0
  %2 = fcmp ole <4 x float> %1, %a1
  %3 = sext <4 x i1> %2 to <4 x i32>
  ret <4 x i32> %3
}

define <8 x i32> @commute_cmpps_eq_ymm(<8 x float>* %a0, <8 x float> %a1) {
; SSE-LABEL: commute_cmpps_eq_ymm:
; SSE:       # BB#0:
; SSE-NEXT:    cmpeqps (%rdi), %xmm0
; SSE-NEXT:    cmpeqps 16(%rdi), %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: commute_cmpps_eq_ymm:
; AVX:       # BB#0:
; AVX-NEXT:    vcmpeqps (%rdi), %ymm0, %ymm0
; AVX-NEXT:    retq
  %1 = load <8 x float>, <8 x float>* %a0
  %2 = fcmp oeq <8 x float> %1, %a1
  %3 = sext <8 x i1> %2 to <8 x i32>
  ret <8 x i32> %3
}

define <8 x i32> @commute_cmpps_ne_ymm(<8 x float>* %a0, <8 x float> %a1) {
; SSE-LABEL: commute_cmpps_ne_ymm:
; SSE:       # BB#0:
; SSE-NEXT:    cmpneqps (%rdi), %xmm0
; SSE-NEXT:    cmpneqps 16(%rdi), %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: commute_cmpps_ne_ymm:
; AVX:       # BB#0:
; AVX-NEXT:    vcmpneqps (%rdi), %ymm0, %ymm0
; AVX-NEXT:    retq
  %1 = load <8 x float>, <8 x float>* %a0
  %2 = fcmp une <8 x float> %1, %a1
  %3 = sext <8 x i1> %2 to <8 x i32>
  ret <8 x i32> %3
}

define <8 x i32> @commute_cmpps_ord_ymm(<8 x float>* %a0, <8 x float> %a1) {
; SSE-LABEL: commute_cmpps_ord_ymm:
; SSE:       # BB#0:
; SSE-NEXT:    cmpordps (%rdi), %xmm0
; SSE-NEXT:    cmpordps 16(%rdi), %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: commute_cmpps_ord_ymm:
; AVX:       # BB#0:
; AVX-NEXT:    vcmpordps (%rdi), %ymm0, %ymm0
; AVX-NEXT:    retq
  %1 = load <8 x float>, <8 x float>* %a0
  %2 = fcmp ord <8 x float> %1, %a1
  %3 = sext <8 x i1> %2 to <8 x i32>
  ret <8 x i32> %3
}

define <8 x i32> @commute_cmpps_uno_ymm(<8 x float>* %a0, <8 x float> %a1) {
; SSE-LABEL: commute_cmpps_uno_ymm:
; SSE:       # BB#0:
; SSE-NEXT:    cmpunordps (%rdi), %xmm0
; SSE-NEXT:    cmpunordps 16(%rdi), %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: commute_cmpps_uno_ymm:
; AVX:       # BB#0:
; AVX-NEXT:    vcmpunordps (%rdi), %ymm0, %ymm0
; AVX-NEXT:    retq
  %1 = load <8 x float>, <8 x float>* %a0
  %2 = fcmp uno <8 x float> %1, %a1
  %3 = sext <8 x i1> %2 to <8 x i32>
  ret <8 x i32> %3
}

define <8 x i32> @commute_cmpps_ueq_ymm(<8 x float>* %a0, <8 x float> %a1) {
; SSE-LABEL: commute_cmpps_ueq_ymm:
; SSE:       # BB#0:
; SSE-NEXT:    movaps (%rdi), %xmm2
; SSE-NEXT:    movaps 16(%rdi), %xmm3
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    cmpeqps %xmm0, %xmm4
; SSE-NEXT:    cmpunordps %xmm2, %xmm0
; SSE-NEXT:    orps %xmm4, %xmm0
; SSE-NEXT:    movaps %xmm3, %xmm2
; SSE-NEXT:    cmpeqps %xmm1, %xmm2
; SSE-NEXT:    cmpunordps %xmm3, %xmm1
; SSE-NEXT:    orps %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: commute_cmpps_ueq_ymm:
; AVX:       # BB#0:
; AVX-NEXT:    vmovaps (%rdi), %ymm1
; AVX-NEXT:    vcmpeqps %ymm0, %ymm1, %ymm2
; AVX-NEXT:    vcmpunordps %ymm0, %ymm1, %ymm0
; AVX-NEXT:    vorps %ymm2, %ymm0, %ymm0
; AVX-NEXT:    retq
  %1 = load <8 x float>, <8 x float>* %a0
  %2 = fcmp ueq <8 x float> %1, %a1
  %3 = sext <8 x i1> %2 to <8 x i32>
  ret <8 x i32> %3
}

define <8 x i32> @commute_cmpps_one_ymm(<8 x float>* %a0, <8 x float> %a1) {
; SSE-LABEL: commute_cmpps_one_ymm:
; SSE:       # BB#0:
; SSE-NEXT:    movaps (%rdi), %xmm2
; SSE-NEXT:    movaps 16(%rdi), %xmm3
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    cmpneqps %xmm0, %xmm4
; SSE-NEXT:    cmpordps %xmm2, %xmm0
; SSE-NEXT:    andps %xmm4, %xmm0
; SSE-NEXT:    movaps %xmm3, %xmm2
; SSE-NEXT:    cmpneqps %xmm1, %xmm2
; SSE-NEXT:    cmpordps %xmm3, %xmm1
; SSE-NEXT:    andps %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: commute_cmpps_one_ymm:
; AVX:       # BB#0:
; AVX-NEXT:    vmovaps (%rdi), %ymm1
; AVX-NEXT:    vcmpneqps %ymm0, %ymm1, %ymm2
; AVX-NEXT:    vcmpordps %ymm0, %ymm1, %ymm0
; AVX-NEXT:    vandps %ymm2, %ymm0, %ymm0
; AVX-NEXT:    retq
  %1 = load <8 x float>, <8 x float>* %a0
  %2 = fcmp one <8 x float> %1, %a1
  %3 = sext <8 x i1> %2 to <8 x i32>
  ret <8 x i32> %3
}

define <8 x i32> @commute_cmpps_lt_ymm(<8 x float>* %a0, <8 x float> %a1) {
; SSE-LABEL: commute_cmpps_lt_ymm:
; SSE:       # BB#0:
; SSE-NEXT:    movaps (%rdi), %xmm2
; SSE-NEXT:    movaps 16(%rdi), %xmm3
; SSE-NEXT:    cmpltps %xmm0, %xmm2
; SSE-NEXT:    cmpltps %xmm1, %xmm3
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    movaps %xmm3, %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: commute_cmpps_lt_ymm:
; AVX:       # BB#0:
; AVX-NEXT:    vmovaps (%rdi), %ymm1
; AVX-NEXT:    vcmpltps %ymm0, %ymm1, %ymm0
; AVX-NEXT:    retq
  %1 = load <8 x float>, <8 x float>* %a0
  %2 = fcmp olt <8 x float> %1, %a1
  %3 = sext <8 x i1> %2 to <8 x i32>
  ret <8 x i32> %3
}

define <8 x i32> @commute_cmpps_le_ymm(<8 x float>* %a0, <8 x float> %a1) {
; SSE-LABEL: commute_cmpps_le_ymm:
; SSE:       # BB#0:
; SSE-NEXT:    movaps (%rdi), %xmm2
; SSE-NEXT:    movaps 16(%rdi), %xmm3
; SSE-NEXT:    cmpleps %xmm0, %xmm2
; SSE-NEXT:    cmpleps %xmm1, %xmm3
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    movaps %xmm3, %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: commute_cmpps_le_ymm:
; AVX:       # BB#0:
; AVX-NEXT:    vmovaps (%rdi), %ymm1
; AVX-NEXT:    vcmpleps %ymm0, %ymm1, %ymm0
; AVX-NEXT:    retq
  %1 = load <8 x float>, <8 x float>* %a0
  %2 = fcmp ole <8 x float> %1, %a1
  %3 = sext <8 x i1> %2 to <8 x i32>
  ret <8 x i32> %3
}

;
; Double Comparisons
; Only equal/not-equal/ordered/unordered can be safely commuted
;

define <2 x i64> @commute_cmppd_eq(<2 x double>* %a0, <2 x double> %a1) {
; SSE-LABEL: commute_cmppd_eq:
; SSE:       # BB#0:
; SSE-NEXT:    cmpeqpd (%rdi), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: commute_cmppd_eq:
; AVX:       # BB#0:
; AVX-NEXT:    vcmpeqpd (%rdi), %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = load <2 x double>, <2 x double>* %a0
  %2 = fcmp oeq <2 x double> %1, %a1
  %3 = sext <2 x i1> %2 to <2 x i64>
  ret <2 x i64> %3
}

define <2 x i64> @commute_cmppd_ne(<2 x double>* %a0, <2 x double> %a1) {
; SSE-LABEL: commute_cmppd_ne:
; SSE:       # BB#0:
; SSE-NEXT:    cmpneqpd (%rdi), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: commute_cmppd_ne:
; AVX:       # BB#0:
; AVX-NEXT:    vcmpneqpd (%rdi), %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = load <2 x double>, <2 x double>* %a0
  %2 = fcmp une <2 x double> %1, %a1
  %3 = sext <2 x i1> %2 to <2 x i64>
  ret <2 x i64> %3
}

define <2 x i64> @commute_cmppd_ord(<2 x double>* %a0, <2 x double> %a1) {
; SSE-LABEL: commute_cmppd_ord:
; SSE:       # BB#0:
; SSE-NEXT:    cmpordpd (%rdi), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: commute_cmppd_ord:
; AVX:       # BB#0:
; AVX-NEXT:    vcmpordpd (%rdi), %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = load <2 x double>, <2 x double>* %a0
  %2 = fcmp ord <2 x double> %1, %a1
  %3 = sext <2 x i1> %2 to <2 x i64>
  ret <2 x i64> %3
}

define <2 x i64> @commute_cmppd_ueq(<2 x double>* %a0, <2 x double> %a1) {
; SSE-LABEL: commute_cmppd_ueq:
; SSE:       # BB#0:
; SSE-NEXT:    movapd (%rdi), %xmm1
; SSE-NEXT:    movapd %xmm1, %xmm2
; SSE-NEXT:    cmpeqpd %xmm0, %xmm2
; SSE-NEXT:    cmpunordpd %xmm1, %xmm0
; SSE-NEXT:    orpd %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: commute_cmppd_ueq:
; AVX:       # BB#0:
; AVX-NEXT:    vmovapd (%rdi), %xmm1
; AVX-NEXT:    vcmpeqpd %xmm0, %xmm1, %xmm2
; AVX-NEXT:    vcmpunordpd %xmm0, %xmm1, %xmm0
; AVX-NEXT:    vorpd %xmm2, %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = load <2 x double>, <2 x double>* %a0
  %2 = fcmp ueq <2 x double> %1, %a1
  %3 = sext <2 x i1> %2 to <2 x i64>
  ret <2 x i64> %3
}

define <2 x i64> @commute_cmppd_one(<2 x double>* %a0, <2 x double> %a1) {
; SSE-LABEL: commute_cmppd_one:
; SSE:       # BB#0:
; SSE-NEXT:    movapd (%rdi), %xmm1
; SSE-NEXT:    movapd %xmm1, %xmm2
; SSE-NEXT:    cmpneqpd %xmm0, %xmm2
; SSE-NEXT:    cmpordpd %xmm1, %xmm0
; SSE-NEXT:    andpd %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: commute_cmppd_one:
; AVX:       # BB#0:
; AVX-NEXT:    vmovapd (%rdi), %xmm1
; AVX-NEXT:    vcmpneqpd %xmm0, %xmm1, %xmm2
; AVX-NEXT:    vcmpordpd %xmm0, %xmm1, %xmm0
; AVX-NEXT:    vandpd %xmm2, %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = load <2 x double>, <2 x double>* %a0
  %2 = fcmp one <2 x double> %1, %a1
  %3 = sext <2 x i1> %2 to <2 x i64>
  ret <2 x i64> %3
}

define <2 x i64> @commute_cmppd_uno(<2 x double>* %a0, <2 x double> %a1) {
; SSE-LABEL: commute_cmppd_uno:
; SSE:       # BB#0:
; SSE-NEXT:    cmpunordpd (%rdi), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: commute_cmppd_uno:
; AVX:       # BB#0:
; AVX-NEXT:    vcmpunordpd (%rdi), %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = load <2 x double>, <2 x double>* %a0
  %2 = fcmp uno <2 x double> %1, %a1
  %3 = sext <2 x i1> %2 to <2 x i64>
  ret <2 x i64> %3
}

define <2 x i64> @commute_cmppd_lt(<2 x double>* %a0, <2 x double> %a1) {
; SSE-LABEL: commute_cmppd_lt:
; SSE:       # BB#0:
; SSE-NEXT:    movapd (%rdi), %xmm1
; SSE-NEXT:    cmpltpd %xmm0, %xmm1
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: commute_cmppd_lt:
; AVX:       # BB#0:
; AVX-NEXT:    vmovapd (%rdi), %xmm1
; AVX-NEXT:    vcmpltpd %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
  %1 = load <2 x double>, <2 x double>* %a0
  %2 = fcmp olt <2 x double> %1, %a1
  %3 = sext <2 x i1> %2 to <2 x i64>
  ret <2 x i64> %3
}

define <2 x i64> @commute_cmppd_le(<2 x double>* %a0, <2 x double> %a1) {
; SSE-LABEL: commute_cmppd_le:
; SSE:       # BB#0:
; SSE-NEXT:    movapd (%rdi), %xmm1
; SSE-NEXT:    cmplepd %xmm0, %xmm1
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: commute_cmppd_le:
; AVX:       # BB#0:
; AVX-NEXT:    vmovapd (%rdi), %xmm1
; AVX-NEXT:    vcmplepd %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
  %1 = load <2 x double>, <2 x double>* %a0
  %2 = fcmp ole <2 x double> %1, %a1
  %3 = sext <2 x i1> %2 to <2 x i64>
  ret <2 x i64> %3
}

define <4 x i64> @commute_cmppd_eq_ymmm(<4 x double>* %a0, <4 x double> %a1) {
; SSE-LABEL: commute_cmppd_eq_ymmm:
; SSE:       # BB#0:
; SSE-NEXT:    cmpeqpd (%rdi), %xmm0
; SSE-NEXT:    cmpeqpd 16(%rdi), %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: commute_cmppd_eq_ymmm:
; AVX:       # BB#0:
; AVX-NEXT:    vcmpeqpd (%rdi), %ymm0, %ymm0
; AVX-NEXT:    retq
  %1 = load <4 x double>, <4 x double>* %a0
  %2 = fcmp oeq <4 x double> %1, %a1
  %3 = sext <4 x i1> %2 to <4 x i64>
  ret <4 x i64> %3
}

define <4 x i64> @commute_cmppd_ne_ymmm(<4 x double>* %a0, <4 x double> %a1) {
; SSE-LABEL: commute_cmppd_ne_ymmm:
; SSE:       # BB#0:
; SSE-NEXT:    cmpneqpd (%rdi), %xmm0
; SSE-NEXT:    cmpneqpd 16(%rdi), %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: commute_cmppd_ne_ymmm:
; AVX:       # BB#0:
; AVX-NEXT:    vcmpneqpd (%rdi), %ymm0, %ymm0
; AVX-NEXT:    retq
  %1 = load <4 x double>, <4 x double>* %a0
  %2 = fcmp une <4 x double> %1, %a1
  %3 = sext <4 x i1> %2 to <4 x i64>
  ret <4 x i64> %3
}

define <4 x i64> @commute_cmppd_ord_ymmm(<4 x double>* %a0, <4 x double> %a1) {
; SSE-LABEL: commute_cmppd_ord_ymmm:
; SSE:       # BB#0:
; SSE-NEXT:    cmpordpd (%rdi), %xmm0
; SSE-NEXT:    cmpordpd 16(%rdi), %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: commute_cmppd_ord_ymmm:
; AVX:       # BB#0:
; AVX-NEXT:    vcmpordpd (%rdi), %ymm0, %ymm0
; AVX-NEXT:    retq
  %1 = load <4 x double>, <4 x double>* %a0
  %2 = fcmp ord <4 x double> %1, %a1
  %3 = sext <4 x i1> %2 to <4 x i64>
  ret <4 x i64> %3
}

define <4 x i64> @commute_cmppd_uno_ymmm(<4 x double>* %a0, <4 x double> %a1) {
; SSE-LABEL: commute_cmppd_uno_ymmm:
; SSE:       # BB#0:
; SSE-NEXT:    cmpunordpd (%rdi), %xmm0
; SSE-NEXT:    cmpunordpd 16(%rdi), %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: commute_cmppd_uno_ymmm:
; AVX:       # BB#0:
; AVX-NEXT:    vcmpunordpd (%rdi), %ymm0, %ymm0
; AVX-NEXT:    retq
  %1 = load <4 x double>, <4 x double>* %a0
  %2 = fcmp uno <4 x double> %1, %a1
  %3 = sext <4 x i1> %2 to <4 x i64>
  ret <4 x i64> %3
}

define <4 x i64> @commute_cmppd_ueq_ymmm(<4 x double>* %a0, <4 x double> %a1) {
; SSE-LABEL: commute_cmppd_ueq_ymmm:
; SSE:       # BB#0:
; SSE-NEXT:    movapd (%rdi), %xmm2
; SSE-NEXT:    movapd 16(%rdi), %xmm3
; SSE-NEXT:    movapd %xmm2, %xmm4
; SSE-NEXT:    cmpeqpd %xmm0, %xmm4
; SSE-NEXT:    cmpunordpd %xmm2, %xmm0
; SSE-NEXT:    orpd %xmm4, %xmm0
; SSE-NEXT:    movapd %xmm3, %xmm2
; SSE-NEXT:    cmpeqpd %xmm1, %xmm2
; SSE-NEXT:    cmpunordpd %xmm3, %xmm1
; SSE-NEXT:    orpd %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: commute_cmppd_ueq_ymmm:
; AVX:       # BB#0:
; AVX-NEXT:    vmovapd (%rdi), %ymm1
; AVX-NEXT:    vcmpeqpd %ymm0, %ymm1, %ymm2
; AVX-NEXT:    vcmpunordpd %ymm0, %ymm1, %ymm0
; AVX-NEXT:    vorpd %ymm2, %ymm0, %ymm0
; AVX-NEXT:    retq
  %1 = load <4 x double>, <4 x double>* %a0
  %2 = fcmp ueq <4 x double> %1, %a1
  %3 = sext <4 x i1> %2 to <4 x i64>
  ret <4 x i64> %3
}

define <4 x i64> @commute_cmppd_one_ymmm(<4 x double>* %a0, <4 x double> %a1) {
; SSE-LABEL: commute_cmppd_one_ymmm:
; SSE:       # BB#0:
; SSE-NEXT:    movapd (%rdi), %xmm2
; SSE-NEXT:    movapd 16(%rdi), %xmm3
; SSE-NEXT:    movapd %xmm2, %xmm4
; SSE-NEXT:    cmpneqpd %xmm0, %xmm4
; SSE-NEXT:    cmpordpd %xmm2, %xmm0
; SSE-NEXT:    andpd %xmm4, %xmm0
; SSE-NEXT:    movapd %xmm3, %xmm2
; SSE-NEXT:    cmpneqpd %xmm1, %xmm2
; SSE-NEXT:    cmpordpd %xmm3, %xmm1
; SSE-NEXT:    andpd %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: commute_cmppd_one_ymmm:
; AVX:       # BB#0:
; AVX-NEXT:    vmovapd (%rdi), %ymm1
; AVX-NEXT:    vcmpneqpd %ymm0, %ymm1, %ymm2
; AVX-NEXT:    vcmpordpd %ymm0, %ymm1, %ymm0
; AVX-NEXT:    vandpd %ymm2, %ymm0, %ymm0
; AVX-NEXT:    retq
  %1 = load <4 x double>, <4 x double>* %a0
  %2 = fcmp one <4 x double> %1, %a1
  %3 = sext <4 x i1> %2 to <4 x i64>
  ret <4 x i64> %3
}

define <4 x i64> @commute_cmppd_lt_ymmm(<4 x double>* %a0, <4 x double> %a1) {
; SSE-LABEL: commute_cmppd_lt_ymmm:
; SSE:       # BB#0:
; SSE-NEXT:    movapd (%rdi), %xmm2
; SSE-NEXT:    movapd 16(%rdi), %xmm3
; SSE-NEXT:    cmpltpd %xmm0, %xmm2
; SSE-NEXT:    cmpltpd %xmm1, %xmm3
; SSE-NEXT:    movapd %xmm2, %xmm0
; SSE-NEXT:    movapd %xmm3, %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: commute_cmppd_lt_ymmm:
; AVX:       # BB#0:
; AVX-NEXT:    vmovapd (%rdi), %ymm1
; AVX-NEXT:    vcmpltpd %ymm0, %ymm1, %ymm0
; AVX-NEXT:    retq
  %1 = load <4 x double>, <4 x double>* %a0
  %2 = fcmp olt <4 x double> %1, %a1
  %3 = sext <4 x i1> %2 to <4 x i64>
  ret <4 x i64> %3
}

define <4 x i64> @commute_cmppd_le_ymmm(<4 x double>* %a0, <4 x double> %a1) {
; SSE-LABEL: commute_cmppd_le_ymmm:
; SSE:       # BB#0:
; SSE-NEXT:    movapd (%rdi), %xmm2
; SSE-NEXT:    movapd 16(%rdi), %xmm3
; SSE-NEXT:    cmplepd %xmm0, %xmm2
; SSE-NEXT:    cmplepd %xmm1, %xmm3
; SSE-NEXT:    movapd %xmm2, %xmm0
; SSE-NEXT:    movapd %xmm3, %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: commute_cmppd_le_ymmm:
; AVX:       # BB#0:
; AVX-NEXT:    vmovapd (%rdi), %ymm1
; AVX-NEXT:    vcmplepd %ymm0, %ymm1, %ymm0
; AVX-NEXT:    retq
  %1 = load <4 x double>, <4 x double>* %a0
  %2 = fcmp ole <4 x double> %1, %a1
  %3 = sext <4 x i1> %2 to <4 x i64>
  ret <4 x i64> %3
}
