/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.crypto.SecretKey;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.cryptacular.CryptUtil;
import org.cryptacular.EncodingException;
import org.cryptacular.StreamException;
import org.cryptacular.util.ByteUtil;

public class CiphertextHeader {
    private static final int VERSION = -2;
    private static final int HMAC_SIZE = 32;
    private static final int MAX_NONCE_LEN = 255;
    private static final int MAX_KEYNAME_LEN = 500;
    private final byte[] nonce;
    private final String keyName;
    private final int length;
    private final Function<String, SecretKey> keyLookup;

    public CiphertextHeader(byte[] nonce, String keyName) {
        this(nonce, keyName, null);
    }

    public CiphertextHeader(byte[] nonce, String keyName, Function<String, SecretKey> keyLookup) {
        CryptUtil.assertNotNullArg(nonce, "Nonce cannot be null");
        if (nonce.length > 255) {
            throw new IllegalArgumentException("Nonce exceeds size limit in bytes (255)");
        }
        CryptUtil.assertNotNullArgOr(keyName, String::isEmpty, "Key name can not be null or empty");
        if (ByteUtil.toBytes(keyName).length > 500) {
            throw new IllegalArgumentException("Key name exceeds size limit in bytes (500)");
        }
        this.nonce = nonce;
        this.keyName = keyName;
        this.keyLookup = keyLookup;
        this.length = this.computeLength();
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public byte[] encode() {
        SecretKey key;
        SecretKey secretKey = key = this.keyLookup != null ? this.keyLookup.apply(this.keyName) : null;
        if (key == null) {
            throw new IllegalStateException("Could not resolve secret key to generate header HMAC");
        }
        return this.encode(key);
    }

    public byte[] encode(SecretKey hmacKey) {
        CryptUtil.assertNotNullArg(hmacKey, "Secret key cannot be null");
        ByteBuffer bb = ByteBuffer.allocate(this.length);
        bb.order(ByteOrder.BIG_ENDIAN);
        bb.putInt(-2);
        bb.put(ByteUtil.toBytes(this.keyName));
        bb.put((byte)0);
        bb.put(ByteUtil.toUnsignedByte(this.nonce.length));
        bb.put(this.nonce);
        bb.put(CiphertextHeader.hmac(bb.array(), 0, bb.limit() - 32));
        return bb.array();
    }

    protected int computeLength() {
        return 4 + ByteUtil.toBytes(this.keyName).length + 2 + this.nonce.length + 32;
    }

    public static CiphertextHeader decode(byte[] data, Function<String, SecretKey> keyLookup) throws EncodingException {
        CryptUtil.assertNotNullArg(data, "Data cannot be null");
        CryptUtil.assertNotNullArg(keyLookup, "Key lookup cannot be null");
        ByteBuffer bb = ByteBuffer.wrap(data).order(ByteOrder.BIG_ENDIAN);
        return CiphertextHeader.decodeInternal(ByteBuffer.wrap(data).order(ByteOrder.BIG_ENDIAN), keyLookup, ByteBuffer2 -> bb.getInt(), ByteBuffer2 -> bb.get(), (ByteBuffer2, output) -> bb.get((byte[])output));
    }

    public static CiphertextHeader decode(InputStream input, Function<String, SecretKey> keyLookup) throws EncodingException, StreamException {
        return CiphertextHeader.decodeInternal(CryptUtil.assertNotNullArg(input, "Input stream cannot be null"), CryptUtil.assertNotNullArg(keyLookup, "Key lookup cannot be null"), ByteUtil::readInt, CiphertextHeader::readByte, CiphertextHeader::readInto);
    }

    private static <T> CiphertextHeader decodeInternal(T source, Function<String, SecretKey> keyLookup, Function<T, Integer> readIntFn, Function<T, Byte> readByteFn, BiConsumer<T, byte[]> readBytesConsumer) {
        byte[] hmac;
        byte[] nonce;
        SecretKey key;
        String keyName;
        try {
            byte b;
            int version = readIntFn.apply(source);
            if (version != -2) {
                throw new EncodingException("Unsupported ciphertext header version");
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream(100);
            int count = 0;
            while ((b = readByteFn.apply(source).byteValue()) != 0) {
                out.write(b);
                if (out.size() > 500) {
                    throw new EncodingException("Bad ciphertext header: maximum nonce length exceeded");
                }
                ++count;
            }
            keyName = ByteUtil.toString(out.toByteArray(), 0, count);
            key = keyLookup.apply(keyName);
            if (key == null) {
                throw new IllegalStateException("Symbolic key name mentioned in header was not found");
            }
            int nonceLen = ByteUtil.toInt(readByteFn.apply(source));
            nonce = new byte[nonceLen];
            readBytesConsumer.accept(source, nonce);
            hmac = new byte[32];
            readBytesConsumer.accept(source, hmac);
        }
        catch (IndexOutOfBoundsException | BufferUnderflowException e) {
            throw new EncodingException("Bad ciphertext header");
        }
        CiphertextHeader header = new CiphertextHeader(nonce, keyName, keyLookup);
        byte[] encoded = header.encode(key);
        if (!CiphertextHeader.arraysEqual(hmac, 0, encoded, encoded.length - 32, 32)) {
            throw new EncodingException("Ciphertext header HMAC verification failed");
        }
        return header;
    }

    private static byte[] hmac(byte[] input, int offset, int length) {
        HMac hmac = new HMac((Digest)new SHA256Digest());
        byte[] output = new byte[32];
        hmac.update(input, offset, length);
        hmac.doFinal(output, 0);
        return output;
    }

    private static int readInto(InputStream input, byte[] output) {
        try {
            return input.read(output);
        }
        catch (IOException e) {
            throw new StreamException(e);
        }
    }

    private static byte readByte(InputStream input) {
        try {
            return (byte)input.read();
        }
        catch (IOException e) {
            throw new StreamException(e);
        }
    }

    private static boolean arraysEqual(byte[] a, int aOff, byte[] b, int bOff, int length) {
        if (length + aOff > a.length || length + bOff > b.length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (a[i + aOff] == b[i + bOff]) continue;
            return false;
        }
        return true;
    }
}

