/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.ip2geo.dao;

import java.io.IOException;
import java.time.Instant;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.cache.Cache;
import org.opensearch.common.cache.CacheBuilder;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.geospatial.annotation.VisibleForTesting;
import org.opensearch.geospatial.ip2geo.common.DatasourceState;
import org.opensearch.geospatial.ip2geo.common.Ip2GeoSettings;
import org.opensearch.geospatial.ip2geo.dao.DatasourceDao;
import org.opensearch.geospatial.ip2geo.dao.GeoIpDataDao;
import org.opensearch.geospatial.ip2geo.jobscheduler.Datasource;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.engine.Engine;
import org.opensearch.index.shard.IndexingOperationListener;

public class Ip2GeoCachedDao
implements IndexingOperationListener {
    @Generated
    private static final Logger log = LogManager.getLogger(Ip2GeoCachedDao.class);
    private final DatasourceDao datasourceDao;
    private final GeoIpDataDao geoIpDataDao;
    private final GeoDataCache geoDataCache;
    private Map<String, DatasourceMetadata> metadata;

    public Ip2GeoCachedDao(ClusterService clusterService, DatasourceDao datasourceDao, GeoIpDataDao geoIpDataDao) {
        this.datasourceDao = datasourceDao;
        this.geoIpDataDao = geoIpDataDao;
        this.geoDataCache = new GeoDataCache((Long)clusterService.getClusterSettings().get(Ip2GeoSettings.CACHE_SIZE));
        clusterService.getClusterSettings().addSettingsUpdateConsumer(Ip2GeoSettings.CACHE_SIZE, setting -> this.geoDataCache.updateMaxSize((long)setting));
    }

    private String doGetIndexName(String datasourceName) {
        return this.getMetadata().getOrDefault(datasourceName, DatasourceMetadata.EMPTY_METADATA).getIndexName();
    }

    public String getIndexName(String datasourceName) {
        String indexName = this.doGetIndexName(datasourceName);
        if (indexName == null) {
            this.refreshDatasource(datasourceName);
            indexName = this.doGetIndexName(datasourceName);
        }
        return indexName;
    }

    private boolean doIsExpired(String datasourceName) {
        Instant now;
        Instant expirationDate = this.getMetadata().getOrDefault(datasourceName, DatasourceMetadata.EMPTY_METADATA).getExpirationDate();
        boolean isExpired = expirationDate.isBefore(now = Instant.now());
        if (isExpired) {
            log.warn("Datasource {} is expired. Expiration date is {} and now is {}.", (Object)datasourceName, (Object)expirationDate, (Object)now);
        }
        return isExpired;
    }

    public boolean isExpired(String datasourceName) {
        boolean isExpired = this.doIsExpired(datasourceName);
        if (isExpired) {
            this.refreshDatasource(datasourceName);
            isExpired = this.doIsExpired(datasourceName);
        }
        return isExpired;
    }

    private boolean doHas(String datasourceName) {
        return this.getMetadata().containsKey(datasourceName);
    }

    public boolean has(String datasourceName) {
        boolean isExist = this.doHas(datasourceName);
        if (!isExist) {
            this.refreshDatasource(datasourceName);
            isExist = this.doHas(datasourceName);
        }
        return isExist;
    }

    private DatasourceState doGetState(String datasourceName) {
        return this.getMetadata().getOrDefault(datasourceName, DatasourceMetadata.EMPTY_METADATA).getState();
    }

    public DatasourceState getState(String datasourceName) {
        DatasourceState state = this.doGetState(datasourceName);
        if (!DatasourceState.AVAILABLE.equals((Object)state)) {
            this.refreshDatasource(datasourceName);
            state = this.doGetState(datasourceName);
        }
        return state;
    }

    private Map<String, Object> doGetGeoData(String indexName, String ip) throws ExecutionException {
        return this.geoDataCache.putIfAbsent(indexName, ip, addr -> this.geoIpDataDao.getGeoIpData(indexName, ip));
    }

    public Map<String, Object> getGeoData(String indexName, String ip, String datasourceName) {
        Map<String, Object> geoData;
        try {
            geoData = this.doGetGeoData(indexName, ip);
        }
        catch (Exception e) {
            this.refreshDatasource(datasourceName);
            try {
                geoData = this.doGetGeoData(indexName, ip);
            }
            catch (Exception ex) {
                log.error("Fail to get geo data.", (Throwable)e);
                throw new RuntimeException(ex);
            }
        }
        return geoData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, DatasourceMetadata> getMetadata() {
        Map<String, DatasourceMetadata> currentMetadata = this.metadata;
        if (currentMetadata != null) {
            return currentMetadata;
        }
        Ip2GeoCachedDao ip2GeoCachedDao = this;
        synchronized (ip2GeoCachedDao) {
            currentMetadata = this.metadata;
            if (currentMetadata != null) {
                return currentMetadata;
            }
            currentMetadata = new ConcurrentHashMap<String, DatasourceMetadata>();
            try {
                for (Datasource datasource : this.datasourceDao.getAllDatasources()) {
                    currentMetadata.put(datasource.getName(), new DatasourceMetadata(datasource));
                }
            }
            catch (IndexNotFoundException e) {
                log.debug("Datasource has never been created");
            }
            this.metadata = currentMetadata;
            return currentMetadata;
        }
    }

    private void put(Datasource datasource) {
        DatasourceMetadata metadata = new DatasourceMetadata(datasource);
        this.getMetadata().put(datasource.getName(), metadata);
    }

    private void remove(String datasourceName) {
        this.getMetadata().remove(datasourceName);
    }

    private void refreshDatasource(String datasourceName) {
        try {
            log.info("Refresh datasource.");
            Datasource datasource = this.datasourceDao.getDatasource(datasourceName);
            if (datasource != null) {
                this.getMetadata().put(datasourceName, new DatasourceMetadata(datasource));
            } else {
                this.getMetadata().remove(datasourceName);
            }
        }
        catch (Exception e) {
            log.error("Fail to refresh the datasource.", (Throwable)e);
            this.clearMetadata();
        }
    }

    private void clearMetadata() {
        log.info("Resetting all datasource metadata to force a refresh from the primary index shard.");
        this.metadata = null;
    }

    public void postIndex(ShardId shardId, Engine.Index index, Exception ex) {
        log.error("Skipped updating datasource metadata for datasource {} due to an indexing exception: {}", (Object)index.id(), (Object)ex);
        this.clearMetadata();
    }

    public void postIndex(ShardId shardId, Engine.Index index, Engine.IndexResult result) {
        if (Engine.Result.Type.FAILURE.equals((Object)result.getResultType())) {
            log.error("Skipped updating datasource metadata for datasource {} because the indexing result was a failure: {}", (Object)index.id(), (Object)result.getFailure());
            this.clearMetadata();
            return;
        }
        try {
            XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, index.source().utf8ToString());
            parser.nextToken();
            Datasource datasource = (Datasource)Datasource.PARSER.parse(parser, null);
            this.put(datasource);
            log.info("Updated datasource metadata for datasource {} successfully.", (Object)index.id());
        }
        catch (IOException e) {
            log.error("IOException occurred updating datasource metadata for datasource {}: {}", (Object)index.id(), (Object)e);
            this.clearMetadata();
        }
    }

    public void postDelete(ShardId shardId, Engine.Delete delete, Exception ex) {
        log.error("Skipped updating datasource metadata for datasource {} due to an exception: {}", (Object)delete.id(), (Object)ex);
        this.clearMetadata();
    }

    public void postDelete(ShardId shardId, Engine.Delete delete, Engine.DeleteResult result) {
        if (result.getResultType().equals((Object)Engine.Result.Type.FAILURE)) {
            log.error("Skipped updating datasource metadata for datasource {} because the delete result was a failure: {}", (Object)delete.id(), (Object)result.getFailure());
            this.clearMetadata();
            return;
        }
        this.remove(delete.id());
    }

    @VisibleForTesting
    protected static class GeoDataCache {
        private Cache<CacheKey, Map<String, Object>> cache;

        public GeoDataCache(long maxSize) {
            if (maxSize < 0L) {
                throw new IllegalArgumentException("ip2geo max cache size must be 0 or greater");
            }
            this.cache = CacheBuilder.builder().setMaximumWeight(maxSize).build();
        }

        public Map<String, Object> putIfAbsent(String indexName, String ip, Function<String, Map<String, Object>> retrieveFunction) throws ExecutionException {
            CacheKey cacheKey = new CacheKey(indexName, ip);
            return (Map)this.cache.computeIfAbsent((Object)cacheKey, key -> (Map)retrieveFunction.apply(key.ip));
        }

        public Map<String, Object> get(String indexName, String ip) {
            return (Map)this.cache.get((Object)new CacheKey(indexName, ip));
        }

        public void updateMaxSize(long maxSize) {
            if (maxSize < 0L) {
                throw new IllegalArgumentException("ip2geo max cache size must be 0 or greater");
            }
            Cache temp = CacheBuilder.builder().setMaximumWeight(maxSize).build();
            int count = 0;
            Iterator it = this.cache.keys().iterator();
            while (it.hasNext() && (long)count < maxSize) {
                CacheKey key = (CacheKey)it.next();
                temp.put((Object)key, (Object)((Map)this.cache.get((Object)key)));
                ++count;
            }
            this.cache = temp;
        }

        private static class CacheKey {
            private final String indexName;
            private final String ip;

            @Generated
            public CacheKey(String indexName, String ip) {
                this.indexName = indexName;
                this.ip = ip;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CacheKey)) {
                    return false;
                }
                CacheKey other = (CacheKey)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$indexName = this.indexName;
                String other$indexName = other.indexName;
                if (this$indexName == null ? other$indexName != null : !this$indexName.equals(other$indexName)) {
                    return false;
                }
                String this$ip = this.ip;
                String other$ip = other.ip;
                return !(this$ip == null ? other$ip != null : !this$ip.equals(other$ip));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof CacheKey;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $indexName = this.indexName;
                result = result * 59 + ($indexName == null ? 43 : $indexName.hashCode());
                String $ip = this.ip;
                result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
                return result;
            }
        }
    }

    private static class DatasourceMetadata {
        private static DatasourceMetadata EMPTY_METADATA = new DatasourceMetadata();
        private String indexName;
        private Instant expirationDate;
        private DatasourceState state;

        private DatasourceMetadata() {
            this.expirationDate = Instant.MIN;
        }

        public DatasourceMetadata(Datasource datasource) {
            this.indexName = datasource.currentIndexName();
            this.expirationDate = datasource.expirationDay();
            this.state = datasource.getState();
        }

        @Generated
        public String getIndexName() {
            return this.indexName;
        }

        @Generated
        public Instant getExpirationDate() {
            return this.expirationDate;
        }

        @Generated
        public DatasourceState getState() {
            return this.state;
        }
    }
}

