/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.rollover;

import java.util.Objects;
import org.opensearch.Version;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.xcontent.ToXContentFragment;

@PublicApi(since="1.0.0")
public abstract class Condition<T>
implements NamedWriteable,
ToXContentFragment {
    protected T value;
    protected final String name;

    protected Condition(String name) {
        this.name = name;
    }

    public abstract Result evaluate(Stats var1);

    boolean includedInVersion(Version version) {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Condition condition = (Condition)o;
        return Objects.equals(this.value, condition.value) && Objects.equals(this.name, condition.name);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.name);
    }

    public final String toString() {
        return "[" + this.name + ": " + String.valueOf(this.value) + "]";
    }

    public T value() {
        return this.value;
    }

    public String name() {
        return this.name;
    }

    @PublicApi(since="1.0.0")
    public static class Result {
        public final Condition<?> condition;
        public final boolean matched;

        protected Result(Condition<?> condition, boolean matched) {
            this.condition = condition;
            this.matched = matched;
        }
    }

    @PublicApi(since="1.0.0")
    public static class Stats {
        public final long numDocs;
        public final long indexCreated;
        public final ByteSizeValue indexSize;

        private Stats(Builder builder) {
            this.numDocs = builder.numDocs;
            this.indexCreated = builder.indexCreated;
            this.indexSize = builder.indexSize;
        }

        @Deprecated
        public Stats(long numDocs, long indexCreated, ByteSizeValue indexSize) {
            this.numDocs = numDocs;
            this.indexCreated = indexCreated;
            this.indexSize = indexSize;
        }

        public static class Builder {
            private long numDocs = 0L;
            private long indexCreated = 0L;
            private ByteSizeValue indexSize = null;

            public Builder numDocs(long numDocs) {
                this.numDocs = numDocs;
                return this;
            }

            public Builder indexCreated(long indexCreated) {
                this.indexCreated = indexCreated;
                return this;
            }

            public Builder indexSize(ByteSizeValue size) {
                this.indexSize = size;
                return this;
            }

            public Stats build() {
                return new Stats(this);
            }
        }
    }
}

